/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.DialogPanel;
import ibm.nways.nhm.eui.NhmDataRetriever;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCMultiColumnList;

public class OptionsDialog
extends Panel
implements ActionListener,
JCItemListener {
    private static char DELIM = (char)124;
    private JCMultiColumnList keywordList;
    private TextField efValue;
    private Label keyTag;
    private Button pbEdit;
    private Button pbOk;
    private Button pbCancel;
    private Button pbHelp;
    private DialogPanel dlgPanel;
    private NhmDataRetriever dataRetriever;
    private Applet appl;
    private Hashtable htable;
    private Vector selectedItem;
    private int selectedIndex;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");
    public static String[] REPORT_OPTION_KEYWORDS = new String[]{"weekday_start_day", "weekday_end_day", "weekday_start_time", "weekday_end_time", "start_day_of_week", "codebase"};
    public static String[] REPORT_OPTION_DEFAULTS = new String[]{"2", "5", "6:00 AM", "6:00 PM", "1", "../code"};

    public OptionsDialog(DpAdminPanel dpAdminPanel) {
        this.appl = dpAdminPanel.getApplet();
        this.dataRetriever = new NhmDataRetriever(dpAdminPanel.getServerName(), dpAdminPanel.getServerPort());
        this.initialize();
    }

    private void initialize() {
        this.htable = new Hashtable();
        int n = 0;
        while (n < REPORT_OPTION_KEYWORDS.length) {
            String string = this.dataRetriever.getReportSetting(REPORT_OPTION_KEYWORDS[n]);
            if (string == null) {
                string = "";
            }
            this.htable.put(REPORT_OPTION_KEYWORDS[n], string);
            ++n;
        }
        this.setLayout(new FlowLayout());
        this.dlgPanel = new DialogPanel(new ColumnLayout());
        this.dlgPanel.add(new Label(this.nhmRes.getString("s_OptLabel")));
        this.keywordList = new JCMultiColumnList(5, false);
        n = 0;
        while (n < REPORT_OPTION_KEYWORDS.length) {
            String string = REPORT_OPTION_KEYWORDS[n];
            String string2 = String.valueOf(string) + DELIM + this.htable.get(string);
            this.keywordList.addItem(string2, DELIM);
            ++n;
        }
        this.dlgPanel.add(this.keywordList);
        Panel panel = new Panel();
        this.keyTag = new Label("                              ");
        this.efValue = new TextField(12);
        this.pbEdit = new Button(this.nhmRes.getString("s_Edit"));
        panel.add(this.keyTag);
        panel.add(this.efValue);
        panel.add(this.pbEdit);
        this.dlgPanel.add(panel);
        Panel panel2 = new Panel();
        this.pbOk = new Button(this.nhmRes.getString("s_Apply"));
        this.pbCancel = new Button(this.nhmRes.getString("s_Cancel"));
        this.pbHelp = new Button(this.nhmRes.getString("s_Help"));
        panel2.add(this.pbOk);
        panel2.add(this.pbCancel);
        panel2.add(this.pbHelp);
        this.dlgPanel.add(panel2);
        this.add(this.dlgPanel);
        this.pbEdit.addActionListener(this);
        this.pbOk.addActionListener(this);
        this.pbCancel.addActionListener(this);
        this.pbHelp.addActionListener(this);
        this.pbEdit.setEnabled(false);
        this.keywordList.addItemListener(this);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getStateChange() == 1) {
            this.selectedItem = (Vector)jCItemEvent.getItem();
            this.selectedIndex = this.keywordList.getSelectedIndex();
            this.keyTag.setText((String)this.selectedItem.elementAt(0));
            if (this.selectedItem.size() > 1) {
                ((TextComponent)this.efValue).setText((String)this.selectedItem.elementAt(1));
            } else {
                ((TextComponent)this.efValue).setText("");
            }
            this.pbEdit.setEnabled(true);
            return;
        }
        this.keyTag.setText("                              ");
        this.pbEdit.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pbOk) {
            int n = 0;
            while (n < REPORT_OPTION_KEYWORDS.length) {
                Vector vector = (Vector)this.keywordList.getItem(n);
                String string = (String)this.htable.get(REPORT_OPTION_KEYWORDS[n]);
                if (!string.equals(vector.elementAt(1))) {
                    string = (String)vector.elementAt(1);
                    this.htable.put(REPORT_OPTION_KEYWORDS[n], string);
                    this.dataRetriever.setReportSetting(REPORT_OPTION_KEYWORDS[n], string);
                }
                ++n;
            }
            return;
        }
        if (actionEvent.getSource() == this.pbCancel) {
            int n = 0;
            while (n < REPORT_OPTION_KEYWORDS.length) {
                Vector vector = (Vector)this.keywordList.getItem(n);
                String string = (String)this.htable.get(REPORT_OPTION_KEYWORDS[n]);
                if (!string.equals(vector.elementAt(1))) {
                    vector.setElementAt(this.htable.get(REPORT_OPTION_KEYWORDS[n]), 1);
                }
                ++n;
            }
            this.keywordList.repaint();
            return;
        }
        if (actionEvent.getSource() == this.pbHelp) {
            NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
            if (this.appl instanceof BrowserApplet) {
                BrowserApplet browserApplet = (BrowserApplet)this.appl;
                browserApplet.showHelp(nhmHelpRef);
                return;
            }
            this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
            return;
        }
        if (actionEvent.getSource() == this.pbEdit) {
            if (this.selectedItem.size() > 1) {
                this.selectedItem.setElementAt(this.efValue.getText(), 1);
            } else {
                this.selectedItem.addElement(this.efValue.getText());
                this.keywordList.replaceItem(this.selectedItem, this.selectedIndex);
            }
            this.keywordList.replaceItem(this.selectedItem, this.selectedIndex);
        }
    }
}

